<?php
session_start();
require 'koneksi/koneksi.php'; // Pastikan koneksi database disertakan

if (!isset($_SESSION['struk_pembayaran'])) {
    echo '<script>alert("Data pembayaran tidak ditemukan!");window.location="index.php"</script>';
    exit;
}

$struk = $_SESSION['struk_pembayaran'];
unset($_SESSION['struk_pembayaran']); // Hapus session setelah digunakan

// Ambil data booking berdasarkan kode_booking
$kode_booking = $struk['kode_booking'];
$query = $koneksi->prepare("SELECT nama FROM booking WHERE kode_booking = ?");
$query->execute([$kode_booking]);
$booking = $query->fetch(PDO::FETCH_ASSOC);

// Jika tidak ada nama_pengirim, gunakan nama dari booking
$nama_pengirim = !empty($struk['nama_pengirim']) ? $struk['nama_pengirim'] : $booking['nama'];

include 'header.php';
?>

<br><br>
<div class="container">
    <div class="row">
        <div class="col-sm-6 offset-sm-3">
            <div class="card">
                <div class="card-header text-center">
                    <h3>Struk Pembayaran</h3>
                </div>
                <div class="card-body">
                    <table class="table">
                        <tr>
                            <td>Kode Booking</td>
                            <td>:</td>
                            <td><?php echo $struk['kode_booking']; ?></td>
                        </tr>
                        <tr>
                            <td>No Rekening Tujuan</td>
                            <td>:</td>
                            <td><?php echo $struk['rekening']; ?></td>
                        </tr>
                        <tr>
                            <td>Atas Nama Tujuan</td>
                            <td>:</td>
                            <td><?php echo $struk['atas_nama']; ?></td>
                        </tr>
                        <tr>
                            <td>Nama Pengirim</td>
                            <td>:</td>
                            <td><?php echo $nama_pengirim; ?></td>
                        </tr>
                        <tr>
                            <td>No Rekening Pengirim</td>
                            <td>:</td>
                            <td><?php echo $struk['no_rek_pengirim']; ?></td>
                        </tr>
                        <tr>
                            <td>Tanggal Transfer</td>
                            <td>:</td>
                            <td><?php echo $struk['tgl_transfer']; ?></td>
                        </tr>
                        <tr>
                            <td>Total yg Dibayar</td>
                            <td>:</td>
                            <td>Rp. <?php echo number_format($struk['total_bayar']); ?></td>
                        </tr>
                    </table>
                    <div class="text-center">
                        <button onclick="window.print()" class="btn btn-success">Cetak Struk</button>
                        <a href="index.php" class="btn btn-primary">Kembali</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<br><br><br>

struk.php