// Scroll function courtesy of Scott Dowding; http://stackoverflow.com/questions/487073/check-if-element-is-visible-after-scrolling

$(document).ready(function() {
  // Check if element is scrolled into view
  function isScrolledIntoView(elem) {
    var docViewTop = $(window).scrollTop();
    var docViewBottom = docViewTop + $(window).height();

    var elemTop = $(elem).offset().top;
    var elemBottom = elemTop + $(elem).height();

    return ((elemBottom <= docViewBottom) && (elemTop >= docViewTop));
  }
  // If element is scrolled into view, fade it in
  $(window).scroll(function() {
    $('.scroll-animations .animated').each(function() {
      if (isScrolledIntoView(this) === true) {
        $("#bounceInDown").addClass('bounceInDown');
        $("#FadeInUp").addClass('fadeInUp');
        $("#FadeLeft").addClass('fadeInLeft');
        $("#FadeDown").addClass('fadeInDown');
        $("#FadeRight").addClass('fadeInRight');
      }
    });
  });
});
